IF EXISTS (SELECT 1 FROM sys.objects WHERE [name] = N'TRG_ATUALIZA_PCR_SISTEMAS_CTR_VERSAO_TOTAL' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[TRG_ATUALIZA_PCR_SISTEMAS_CTR_VERSAO_TOTAL];
END;
GO

CREATE TRIGGER TRG_ATUALIZA_PCR_SISTEMAS_CTR_VERSAO_TOTAL
ON PRC_SISTEMAS_CTR_VERSAO
AFTER INSERT, UPDATE
AS
BEGIN
    SET NOCOUNT ON;

    IF ((SELECT TRIGGER_NESTLEVEL()) > 1) RETURN;

    -- Lidar com inserção ou atualização
    MERGE INTO PRC_SISTEMAS_CTR_VERSAO_TOTAL AS PRC_TOTAL
    USING (SELECT CD_CTR, CD_USU, DT_HR_LOGIN, END_IP, MAQUINA, SISTEMA, VERSAO FROM inserted) AS PRC
    ON PRC_TOTAL.CD_CTR = PRC.CD_CTR

    -- Se já existir, atualize
    WHEN MATCHED THEN 
        UPDATE
    SET
     
        CD_USU = PRC.CD_USU,
        DT_HR_LOGIN = PRC.DT_HR_LOGIN,
        END_IP = PRC.END_IP,
        MAQUINA = PRC.MAQUINA,
        SISTEMA = PRC.SISTEMA,
        VERSAO = PRC.VERSAO

    -- Se não existir, insira
    WHEN NOT MATCHED THEN
    INSERT
        (
        CD_USU,
        DT_HR_LOGIN,
        END_IP,
        MAQUINA,
        SISTEMA,
        VERSAO)
    VALUES (
        PRC.CD_USU,
        PRC.DT_HR_LOGIN,
        PRC.END_IP,
        PRC.MAQUINA,
        PRC.SISTEMA,
        PRC.VERSAO);
END